unit XMLBlocksReg;

{
  Register the XML Building Blocks components.

  Written by Keith Wood (kbwood@iprimus.com.au)
  Version 1.0 - 7 March 2002.
}

interface

{ Tell Delphi about the components }
procedure Register;

implementation

uses
  Classes, TypInfo, DBTables, DesignIntf, DesignEditors, XMLBlocks;

{ TDatabaseNameProperty -------------------------------------------------------}

type
  TDatabaseNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TDatabaseNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDatabaseNameProperty.GetValues(Proc: TGetStrProc);
var
  Index: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    Session.GetDatabaseNames(Values);
    for Index := 0 to Values.Count - 1 do
      Proc(Values[Index]);
  finally
    Values.Free;
  end;
end;

{ Register --------------------------------------------------------------------}

{ Tell Delphi about the components }
procedure Register;
begin
  RegisterComponents('XMLBlocks',
    [TXBBComponent, TXBBComponentCreate, TXBBFork, TXBBMemo, TXBBMerge,
    TXBBParser, TXBBSQL, TXBBStringGrid, TXBBTextFile, TXBBTimestamp,
    TXBBTransform, TXBBTreeView, TXBBWebBrowser, TXBBWriter]);
  RegisterPropertyEditor(TypeInfo(string), TXBBSQL, 'DatabaseName',
    TDatabaseNameProperty);
end;

end.
